install.packages("lme4") #needed for linear mixed modelling
library(lme4) #needed for linear mixed modelling
install.packages("lmerTest") #needed for hypothesis testing in linear mixed modelling
library(lmerTest) #needed for hypothesis testing in linear mixed modelling

mdl1 <- lmer(prob ~ ecocomp + Af + (1|expert) + ecocomp:Af, data=ltoh1wk) #linear mixed model

summary(mdl1) #summary of model with significances

plot(mdl1, type=c("p","smooth"), col.line=1) #testing assumptions of model
lattice::qqmath(mdl1) #testing assumptions of model

mdl1 <- lmer(prob ~ ecocomp + Af + (1|expert) + ecocomp:Af, data=ltoh1wk) #model with random effect

mdl2 <- lm(prob ~ ecocomp + Af + ecocomp:Af, data=ltoh1wk) #model without random effect


pchisq(2*(logLik(mdl1)-logLik(mdl2)), df=1,lower.tail=FALSE)/2 #likelihood ratio test for significance of random effect